library Klasa;

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  Project-View Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the BORLNDMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using BORLNDMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
   SysUtils, Classes, Controls;

type


MOsoba = class
private
   Nazwisko : String;
   Imie     : String;
   DataUr   : TDate;

public
   function    GetNazwisko() : String; virtual;
   function    GetImie() : String; virtual;
   function    GetDataUr() : TDate; virtual;

   procedure   SetNazwisko(Value: String); virtual;
   procedure   SetImie(Value: String); virtual;
   procedure   SetDataUr(Value: TDate); virtual;

   constructor Create(); virtual;
end;

{$R *.res}
{------------------------------------------------------------------------------}
constructor MOsoba.Create();
begin
   Nazwisko := '';
   Imie     := '';
   DataUr   := Date();
end;

function MOsoba.GetDataUr() : TDate;
begin
	Result := DataUr;
end;

function MOsoba.GetImie() : String;
begin
	Result := Imie;
end;

function MOsoba.GetNazwisko() : String;
begin
	Result := Nazwisko;
end;

procedure MOsoba.SetDataUr(Value: TDate);
begin
   DataUr := Value;
end;

procedure MOsoba.SetImie(Value: String);
begin
   Imie := Value;
end;

procedure MOsoba.SetNazwisko(Value: String);
begin
   Nazwisko := Value;
end;

function GetOsoba() : MOsoba; stdcall;
begin
   Result := MOsoba.Create();
end;

function GetOsobaObject() : MOsoba;
begin
	Result := MOsoba.Create();
end;

exports
   GetOsobaObject name 'GetOsobaObject';

begin
end.
